import sys


def readlines(filename):
    """ Read a file and return a list of lines. """
    with open(filename) as file:
        return file.readlines()


def count_pokemon(lines):
    """
    lines: a list of lines, each line is a comma-separated list of values

    Count all of the Pokemon of each type. The type is in column 4
    of the CSV.

    Return a dictionary that maps type to its count.
    """
    # create an empty dictionary
    counts = {}
    # go through the lines
    for line in lines:
        # strip white space and then split on comma
        # tokens is a list of strings, one string per column
        tokens = line.strip().split(',')
        # use list indexing to get the value where the type is listed
        # value is now "water" or "fire" or whatever type
        value = tokens[4]
        # if we haven't seen this type of pokemon before, initialize
        # its count to zero
        if value not in counts:
            counts[value] = 0
        # increment the count by 1
        counts[value] += 1
    # return the dictionary
    return counts


def print_counts(counts):
    """ Print a dictionary that maps words to counts. """
    for value, count in counts.items():
        print(f"{value}: {count}")


def main(filename):
    # read all the lines of the file
    lines = readlines(filename)
    # count the Pokemon of each type
    counts = count_pokemon(lines)
    print_counts(counts)


if __name__ == '__main__':
    main(sys.argv[1])
